document.addEventListener('DOMContentLoaded', function() {
  // Navbar scroll effect
  window.addEventListener('scroll', () => {
    document.querySelector('.navbar').classList.toggle('scrolled', window.scrollY > 50);
  });

  // Hero counters + typewriter
  function animateCounters() {
    document.querySelectorAll('.stat-number').forEach(counter => {
      const target = parseInt(counter.dataset.target);
      let current = 0;
      const increment = target / 100;
      const timer = setInterval(() => {
        current += increment;
        counter.textContent = current >= target ? target : Math.floor(current);
        if (current >= target) clearInterval(timer);
      }, 30);
    });
  }

  function typewriterEffect() {
    const title = document.querySelector('.hero-title');
    const fullText = title.dataset.text;
    title.textContent = '';
    let i = 0;
    const timer = setInterval(() => {
      title.textContent += fullText[i];
      i++;
      if (i >= fullText.length) clearInterval(timer);
    }, 80);
  }

  // Intersection Observer for hero animations
  const heroObserver = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        animateCounters();
        typewriterEffect();
        heroObserver.unobserve(entry.target);
      }
    });
  });
  heroObserver.observe(document.querySelector('.hero-section'));
});



// Doctor section counter animation
const doctorObserver = new IntersectionObserver((entries) => {
  entries.forEach(entry => {
    if (entry.isIntersecting) {
      const counters = entry.target.querySelectorAll('.animate-counter');
      counters.forEach(counter => {
        const target = parseInt(counter.dataset.target);
        let current = 0;
        const timer = setInterval(() => {
          current += target / 80;
          counter.textContent = current >= target ? target : Math.floor(current);
          if (current >= target) clearInterval(timer);
        }, 25);
      });
      doctorObserver.unobserve(entry.target);
    }
  });
});

document.querySelector('.about-section')?.addEventListener('scroll', () => {
  doctorObserver.observe(document.querySelector('.about-section'));
});
